/*
 * Decompiled with CFR 0.152.
 */
package com.exemple.api;

import com.exemple.api.UsersApi;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

@WebServlet(name="UsersApi", urlPatterns={"/api/users/*"})
public class UsersApi
extends HttpServlet {
    private static final Map<Integer, User> DB = new ConcurrentHashMap();
    private static final AtomicInteger SEQ = new AtomicInteger(0);

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.setJson(httpServletResponse);
        String string = httpServletRequest.getPathInfo();
        if (string == null || string.equals("/") || string.isBlank()) {
            httpServletResponse.setStatus(200);
            httpServletResponse.getWriter().write(this.usersToJson());
            return;
        }
        Integer n = this.parseId(string);
        if (n == null) {
            this.sendError(httpServletResponse, 400, "Invalid id in path. Use /api/users/{id}");
            return;
        }
        User user = (User)DB.get(n);
        if (user == null) {
            this.sendError(httpServletResponse, 404, "User not found");
            return;
        }
        httpServletResponse.setStatus(200);
        httpServletResponse.getWriter().write(this.userToJson(n.intValue(), user));
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.setJson(httpServletResponse);
        String string = httpServletRequest.getPathInfo();
        if (string != null && !string.equals("/") && !string.isBlank()) {
            this.sendError(httpServletResponse, 400, "POST must be to /api/users");
            return;
        }
        String string2 = this.readBody(httpServletRequest);
        String string3 = this.extractJsonString(string2, "name");
        String string4 = this.extractJsonString(string2, "email");
        if (string3 == null || string3.isBlank() || string4 == null || string4.isBlank()) {
            this.sendError(httpServletResponse, 400, "Missing fields. Expected JSON: {\"name\":\"...\",\"email\":\"...\"}");
            return;
        }
        int n = SEQ.incrementAndGet();
        DB.put(n, new User(string3.trim(), string4.trim()));
        httpServletResponse.setStatus(201);
        httpServletResponse.setHeader("Location", httpServletRequest.getContextPath() + "/api/users/" + n);
        httpServletResponse.getWriter().write(this.userToJson(n, (User)DB.get(n)));
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.setJson(httpServletResponse);
        Integer n = this.parseId(httpServletRequest.getPathInfo());
        if (n == null) {
            this.sendError(httpServletResponse, 400, "PUT requires /api/users/{id}");
            return;
        }
        User user = (User)DB.get(n);
        if (user == null) {
            this.sendError(httpServletResponse, 404, "User not found");
            return;
        }
        String string = this.readBody(httpServletRequest);
        String string2 = this.extractJsonString(string, "name");
        String string3 = this.extractJsonString(string, "email");
        String string4 = string2 == null || string2.isBlank() ? user.name : string2.trim();
        String string5 = string3 == null || string3.isBlank() ? user.email : string3.trim();
        DB.put(n, new User(string4, string5));
        httpServletResponse.setStatus(200);
        httpServletResponse.getWriter().write(this.userToJson(n.intValue(), (User)DB.get(n)));
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.setJson(httpServletResponse);
        Integer n = this.parseId(httpServletRequest.getPathInfo());
        if (n == null) {
            this.sendError(httpServletResponse, 400, "DELETE requires /api/users/{id}");
            return;
        }
        User user = (User)DB.remove(n);
        if (user == null) {
            this.sendError(httpServletResponse, 404, "User not found");
            return;
        }
        httpServletResponse.setStatus(204);
    }

    private void setJson(HttpServletResponse httpServletResponse) {
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.setContentType("application/json");
    }

    private void sendError(HttpServletResponse httpServletResponse, int n, String string) throws IOException {
        httpServletResponse.setStatus(n);
        httpServletResponse.getWriter().write("{\n  \"ok\": false,\n  \"error\": \"%s\"\n}\n".formatted(this.escapeJson(string)));
    }

    private Integer parseId(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2.isBlank()) {
            return null;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private String readBody(HttpServletRequest httpServletRequest) throws IOException {
        byte[] byArray = httpServletRequest.getInputStream().readAllBytes();
        return new String(byArray, StandardCharsets.UTF_8);
    }

    private String extractJsonString(String string, String string2) {
        if (string == null) {
            return null;
        }
        String string3 = "\"" + string2 + "\"";
        int n = string.indexOf(string3);
        if (n < 0) {
            return null;
        }
        int n2 = string.indexOf(":", n + string3.length());
        if (n2 < 0) {
            return null;
        }
        int n3 = string.indexOf("\"", n2 + 1);
        if (n3 < 0) {
            return null;
        }
        int n4 = string.indexOf("\"", n3 + 1);
        if (n4 < 0) {
            return null;
        }
        return string.substring(n3 + 1, n4);
    }

    private String usersToJson() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\n  \"ok\": true,\n  \"data\": [\n");
        boolean bl = true;
        for (Map.Entry entry : DB.entrySet()) {
            if (!bl) {
                stringBuilder.append(",\n");
            }
            bl = false;
            stringBuilder.append("    ").append(this.userToJsonInline(((Integer)entry.getKey()).intValue(), (User)entry.getValue()));
        }
        stringBuilder.append("\n  ]\n}\n");
        return stringBuilder.toString();
    }

    private String userToJson(int n, User user) {
        return "{\n  \"ok\": true,\n  \"data\": " + this.userToJsonInline(n, user) + "\n}\n";
    }

    private String userToJsonInline(int n, User user) {
        return "{\n  \"id\": %d,\n  \"name\": \"%s\",\n  \"email\": \"%s\"\n}".formatted(n, this.escapeJson(user.name), this.escapeJson(user.email)).replace("\n", "\n    ");
    }

    private String escapeJson(String string) {
        return string.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

